<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Plan;
use App\Models\PlanOption;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;

class PlanController extends Controller
{
    // (سازنده حذف شد تا از میدل‌ور روت استفاده شود - طبق رفع خطای قبلی باندل)

    public function index()
    {
        if (auth()->user()->role !== 'super_admin') abort(403); 
        $plans = Plan::latest()->get();
        return view('admin.plans.index', compact('plans'));
    }

    public function create()
    {
        if (auth()->user()->role !== 'super_admin') abort(403); 
        return view('admin.plans.create');
    }

    public function store(Request $request)
    {
        if (auth()->user()->role !== 'super_admin') abort(403); 
        $validatedData = $request->validate([
            'name' => ['required', 'string', 'max:255'],
            'type' => ['required', Rule::in(['installment', 'check'])],
        ]);
        $plan = auth()->user()->plans()->create($validatedData);
        
        // ✅✅✅ خطای شما اینجا بود (خط ۳۶) ✅✅✅
        return redirect()->route('admin.plans.edit', $plan->id);
    }

    public function edit(Plan $plan)
    {
        if (auth()->user()->role !== 'super_admin') abort(403); 
        $plan->load('options');
        return view('admin.plans.edit', compact('plan'));
    }

    public function update(Request $request, Plan $plan)
    {
        if (auth()->user()->role !== 'super_admin') abort(403); 
        $validatedData = $request->validate([
            'name' => ['required', 'string', 'max:255'],
            'type' => ['required', Rule::in(['installment', 'check'])],
        ]);
        $plan->update($validatedData);
        
        // ✅✅✅ این خط نیز اصلاح شد (برای جلوگیری از خطای بعدی) ✅✅✅
        return redirect()->route('admin.plans.edit', $plan->id);
    }

    public function destroy(Plan $plan)
    {
        if (auth()->user()->role !== 'super_admin') abort(403); 
        $plan->delete();
        // ✅✅✅ این خط نیز اصلاح شد ✅✅✅
        return redirect()->route('admin.plans.index');
    }

    public function storeOption(Request $request, Plan $plan)
    {
        if (auth()->user()->role !== 'super_admin') abort(403); 
        $request->validate([
            'months' => ['required', 'integer', 'min:1'],
            'coefficient' => ['required', 'numeric', 'min:0'],
        ]);
        $plan->options()->create($request->all());
        return back();
    }

    public function destroyOption(PlanOption $option)
    {
        if (auth()->user()->role !== 'super_admin') abort(403); 
        $option->delete();
        return back();
    }
}