<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Setting;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class SettingController extends Controller
{
    public function index()
    {
        if (auth()->user()->role !== 'super_admin') abort(403); // بررسی دسترسی

        $settings = Setting::pluck('value', 'key')->all();
        return view('admin.settings.index', compact('settings'));
    }

    public function store(Request $request)
    {
        if (auth()->user()->role !== 'super_admin') abort(403); // بررسی دسترسی

        $rules = [
            'company_name' => 'nullable|string|max:255',
            'company_phone' => 'nullable|string|max:255',
            'company_address' => 'nullable|string',
            'company_logo' => 'nullable|image|mimes:png,jpg,jpeg|max:1024',
        ];
        $validatedData = $request->validate($rules);

        if ($request->hasFile('company_logo')) {
            $oldLogo = Setting::where('key', 'company_logo')->first();
            if ($oldLogo && $oldLogo->value) {
                Storage::disk('public')->delete($oldLogo->value);
            }
            
            $path = $request->file('company_logo')->store('settings', 'public');
            Setting::updateOrCreate(['key' => 'company_logo'], ['value' => $path]);
        }

        foreach ($validatedData as $key => $value) {
            if ($key !== 'company_logo') {
                Setting::updateOrCreate(['key' => $key], ['value' => $value]);
            }
        }

        return back()->with('success', 'تنظیمات با موفقیت ذخیره شد.');
    }
}