<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Invoice;
use Illuminate\Http\Request;

class InvoiceController extends Controller
{
    /**
     * Display a listing of the resource.
     * (لیست پیش فاکتورها با قابلیت فیلتر)
     */
    public function index(Request $request)
    {
        // (اطمینان از دسترسی ادمین یا حسابدار به API)
        if (! $request->user()->tokenCan('accounting:read')) {
             abort(403, 'دسترسی مجاز نیست.');
        }

        $query = Invoice::query()->with([
            'customer:id,name,national_id,mobile', 
            'user:id,name,email', // نماینده
            'planOption.plan:id,name', // طرح
            'products:id,name,code' // محصولات داخل سبد
        ]);

        // فیلتر بر اساس وضعیت
        if ($request->filled('status')) {
            $query->where('status', $request->status);
        }
        
        // فیلتر بر اساس تاریخ (مثال: /api/v1/invoices?from=2025-10-01)
        if ($request->filled('from')) {
            $query->where('created_at', '>=', $request->from);
        }
        if ($request->filled('to')) {
            $query->where('created_at', '<=', $request->to);
        }

        return $query->latest()->paginate(100);
    }

    /**
     * Display the specified resource.
     * (جزئیات کامل یک پیش فاکتور)
     */
    public function show(Request $request, Invoice $invoice)
    {
        if (! $request->user()->tokenCan('accounting:read')) {
             abort(403, 'دسترسی مجاز نیست.');
        }

        $invoice->load([
            'customer', 
            'user', 
            'planOption.plan', 
            'products' // محصولات داخل سبد (pivot data)
        ]);
        
        // مسیرهای فایل چک را (اگر وجود داشت) اضافه می‌کنیم
        $invoice->cheque_files = $invoice->cheque_document_paths ? json_decode($invoice->cheque_document_paths) : [];
        
        return $invoice;
    }
}