<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Http\Requests\Auth\LoginRequest; // (از فاز ۴)
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\View\View;
// (دیگر نیازی به User در اینجا نیست)

class AuthenticatedSessionController extends Controller
{
    /**
     * Display the login view.
     * (بدون تغییر)
     */
    public function create(): View
    {
        return view('auth.login');
    }

    /**
     * Handle an incoming authentication request.
     * (✅✅✅ بازگردانی شده به حالت ورود مستقیم)
     */
    public function store(LoginRequest $request): RedirectResponse
    {
        // ✅ ۱. کلمه عبور را قبل از احراز هویت نگه می‌داریم
        $password = $request->input('password');

        // 2. این متد (از فاز ۴) اکنون کاربر را لاگین می‌کند
        $request->authenticate(); 

        // 3. سشن را بازسازی می‌کند
        $request->session()->regenerate();

        // ✅ ۴. لاگ اوت کردن دستگاه‌های دیگر
        // این متد تمام جلسات دیگر کاربر را باطل می‌کند
        Auth::logoutOtherDevices($password);

        // 5. به داشبورد هدایت می‌کند
        return redirect()->intended(route('dashboard', absolute: false));
    }

    
    // (متدهای showVerifyForm و verifyLogin که در کد SMS بود، در اینجا وجود ندارند)


    /**
     * Destroy an authenticated session.
     * (بدون تغییر)
     */
    public function destroy(Request $request): RedirectResponse
    {
        Auth::guard('web')->logout();

        $request->session()->invalidate();

        $request->session()->regenerateToken();

        return redirect('/');
    }
}