<?php

namespace App\Http\Controllers\RegionalManager;

use App\Http\Controllers\Controller;
use App\Models\Invoice;
use App\Models\Setting;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;

class ApprovalController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        // ... (کد index بدون تغییر) ...
        $managerId = auth()->id();
        $invoicesQuery = Invoice::whereHas('user', function ($query) use ($managerId) {
            $query->where('creator_id', $managerId);
        });
        $invoices = $invoicesQuery->with(['user', 'customer'])
                                 ->withCount('products') 
                                 ->latest()
                                 ->paginate(15);
        return view('regional-manager.invoices.index', compact('invoices'));
    }

    /**
     * Display the specified resource.
     */
    public function show(Invoice $invoice)
    {
        if ($invoice->user->creator_id !== auth()->id()) {
            abort(403);
        }

        $invoice->load(['user', 'customer', 'planOption.plan', 'products']);
        $documents = json_decode($invoice->document_paths, true);
        
        // ✅ START: خواندن فایل‌های چک از دیتابیس
        $cheque_documents = json_decode($invoice->cheque_document_paths, true);
        // ✅ END: خواندن فایل‌های چک

        return view('regional-manager.invoices.show', compact('invoice', 'documents', 'cheque_documents')); // ✅ پاس دادن فایل‌های چک
    }


    public function updateStatus(Request $request, Invoice $invoice)
    {
        // ✅✅✅ START: تغییرات اعمال شد ✅✅✅
        // مدیران منطقه (کارشناسان فروش) دیگر مجاز به تغییر وضعیت نیستند.
        // این کار فقط توسط حسابدار یا مدیر کل انجام می‌شود.
        abort(403, 'THIS ACTION IS UNAUTHORIZED. ONLY ACCOUNTANTS OR SUPER ADMINS CAN UPDATE STATUS.');
        // ✅✅✅ END: تغییرات اعمال شد ✅✅✅
    }

    public function printInvoice(Invoice $invoice)
        {
            if ($invoice->user->creator_id !== auth()->id()) {
                abort(403);
            }
            $invoice->load('customer', 'planOption.plan', 'products');
            $settings = Setting::pluck('value', 'key')->all();
            
            // ✅✅✅ تغییر اینجاست
            return view('agent.show-invoice', [
                'invoice' => $invoice,
                'settings' => $settings
            ]);
        }
}