<?php

namespace App\Http\Controllers\Shared;

use App\Http\Controllers\Controller;
use App\Models\Product;
use Illuminate\Http\Request;
// ❗ Plan::class دیگر در اینجا نیاز نیست
// use App\Models\Plan; 

class ProductController extends Controller
{
    /**
     * ✅✅✅ START: متد index اصلاح شد ✅✅✅
     * این متد اکنون محصولات را برای مدیر منطقه لیست می‌کند (فقط خواندنی)
     */
    public function index(Request $request)
    {
        // ما منطق جستجو و فیلتر را از AdminProductController کپی می‌کنیم
        $query = Product::query();

        if ($request->filled('status')) {
            if ($request->status == 'in_stock') {
                $query->where('stock', '>', 0);
            } elseif ($request->status == 'out_of_stock') {
                $query->where('stock', '=', 0);
            }
        }

        if ($request->filled('search')) {
            $query->where(function ($q) use ($request) {
                $q->where('name', 'like', '%' . $request->search . '%')
                ->orWhere('code', 'like', '%' . $request->search . '%');
            });
        }

        $products = $query->with('category')->latest()->paginate(12);

        // ما از همان ویوی ادمین استفاده می‌کنیم، اما یک فلگ می‌فرستیم
        // تا دکمه‌های ویرایش/افزودن را مخفی کنیم.
        return view('admin.products.index', [
            'products' => $products,
            'is_readonly' => true // ✅ این متغیر جدید است
        ]);
    }
    // ✅✅✅ END: متد اصلاح شده ✅✅✅


    /**
     * نمایش جزئیات کامل یک محصول
     */
    public function show(Product $product)
    {
        // اطمینان از اینکه فقط کاربران مجاز (ادمین، مدیر، نماینده) می‌توانند ببینند
        $user = auth()->user();
        if ($user->role !== 'super_admin' && $user->role !== 'regional_manager' && $user->role !== 'agent') {
            abort(403);
        }

        // بارگذاری دسته‌بندی محصول (اگر وجود داشت)
        $product->load('category');
        
        return view('shared.product-details', compact('product'));
    }
}