<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class CheckAccountantRole
{
    public function handle(Request $request, Closure $next): Response
    {
        // چک کن آیا کاربر لاگین کرده و آیا نقش او 'accountant' است
        if (auth()->check() && auth()->user()->role === 'accountant') {
            return $next($request);
        }

        abort(403, 'THIS ACTION IS UNAUTHORIZED.');
    }
}