<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class CheckAgentRole
{
public function handle(Request $request, Closure $next): Response
{
    // چک کن آیا کاربر لاگین کرده و آیا نقش او 'agent' است
    if (auth()->check() && auth()->user()->role === 'agent') {
        // اگر شرط درست بود، اجازه بده به صفحه بعدی برود
        return $next($request);
    }

    // در غیر این صورت، خطای 403 (عدم دسترسی) را نمایش بده
    abort(403, 'THIS ACTION IS UNAUTHORIZED.');
}
}
