<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class CheckOtpSession
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        // اگر سشن مورد نیاز برای ورود OTP وجود نداشت
        if (! $request->session()->has('login_user_id')) {
            // کاربر را به صفحه لاگین برگردان
            return redirect()->route('login');
        }
        
        return $next($request);
    }
}