<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class CheckRegionalManagerRole
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        // خط دیباگ حذف شد ✅

        if (auth()->check() && auth()->user()->role === 'regional_manager') {
            return $next($request);
        }
        
        // در غیر این صورت، خطای 403 (عدم دسترسی) را نمایش بده
        abort(403, 'THIS ACTION IS UNAUTHORIZED.');
    }
}