<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class CheckSuperAdminRole
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        // چک کن آیا کاربر لاگین کرده و آیا نقش او 'super_admin' است
        if (auth()->check() && auth()->user()->role === 'super_admin') {
            return $next($request);
        }
        
        // در غیر این صورت، خطای 403 (عدم دسترسی) را نمایش بده
        abort(403, 'THIS ACTION IS UNAUTHORIZED.');
    }
}