<?php

namespace App\Imports;

use App\Models\Product;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Concerns\WithValidation;

class ProductsImport implements ToModel, WithHeadingRow, WithValidation
{
    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
    public function model(array $row)
    {
        return new Product([
            'name'   => $row['name'],
            'code'   => $row['code'],
            'price'  => $row['price'],
            'stock'  => $row['stock'],
            'status' => 'active', // وضعیت پیش‌فرض
        ]);
    }

    public function rules(): array
    {
        return [
            'name' => 'required|string',
            'code' => 'required|string|unique:products,code',
            'price' => 'required|numeric',
            'stock' => 'required|integer',
        ];
    }
}
