<?php

namespace App\Imports;

use App\Models\User;
use Illuminate\Support\Facades\Hash;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow; // برای خواندن ردیف اول به عنوان سربرگ
use Maatwebsite\Excel\Concerns\WithValidation; // برای اعتبارسنجی داده‌ها

class UsersImport implements ToModel, WithHeadingRow, WithValidation
{
    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
    public function model(array $row)
    {
        return new User([
            'name'     => $row['name'],
            'email'    => $row['email'],
            'password' => Hash::make($row['password']),
            'role'     => $row['role'] ?? 'agent', // اگر نقش مشخص نشده بود، پیش‌فرض نماینده باشد
            'creator_id' => auth()->id(), // کاربری که درون‌ریزی را انجام داده
        ]);
    }

    public function rules(): array
    {
        return [
            'name' => 'required|string',
            'email' => 'required|email|unique:users,email',
            'password' => 'required|min:8',
        ];
    }
}
