<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Bundle extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'price',
        'status',
    ];

    /**
     * یک باندل شامل چندین محصول است.
     * (رابطه چند-به-چند)
     */
    public function products()
    {
        return $this->belongsToMany(Product::class, 'bundle_product')
                    ->withPivot('quantity'); // تعداد را هم واکشی می‌کنیم
    }
}