<?php

namespace App\Models; // ✅ اصلاح شد: از . (نقطه) به \ (بک‌اسلش) تغییر یافت

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Category extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name',
        'slug',
        'description',
    ];

    /**
     * یک دسته‌بندی می‌تواند محصولات زیادی داشته باشد.
     * (رابطه یک به چند)
     */
    public function products()
    {
        return $this->hasMany(Product::class);
    }
}