<?php
namespace App\Models;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Customer extends Model
{
    use HasFactory;

    protected $fillable = [
        'agent_id', 'name', 'national_id', 'mobile', 'phone', 'address', 'details',
        'description'
    ];

    // هر مشتری به یک نماینده (User) تعلق دارد
    public function agent()
    {
        return $this->belongsTo(User::class, 'agent_id');
    }

    // هر مشتری می‌تواند فاکتورهای زیادی داشته باشد
    public function invoices()
    {
        return $this->hasMany(Invoice::class);
    }
}