<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Invoice extends Model
{
    use HasFactory;

    // --- بخش اصلاح شده ---
    protected $fillable = [
        'user_id',
        // 'product_id', -> ✅ حذف شد
        'plan_option_id',
        'customer_id', 
        'document_paths', 
        'final_price', 
        'paid_amount_cash', 
        'status',
        'cheque_document_paths',
    ];

    public function customer()
    {
        return $this->belongsTo(Customer::class);
    }
    
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function planOption()
    {
        return $this->belongsTo(PlanOption::class);
    }

    // =============================================
    // START: ✅ بخش اصلاح شده برای سبد خرید
    // =============================================
    /**
     * یک فاکتور می‌تواند محصولات زیادی داشته باشد (رابطه چند-به-چند)
     * ما از جدول 'invoice_product' به عنوان جدول میانی استفاده می‌کنیم.
     */
    public function products()
    {
        return $this->belongsToMany(Product::class, 'invoice_product')
                    ->withPivot('quantity', 'price'); // ✅ اطلاعات تعداد و قیمت را هم واکشی می‌کنیم
    }
    // =============================================
    // END: بخش اصلاح شده
    // =============================================
}