<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PlanOption extends Model
{
    use HasFactory;

    protected $fillable = ['plan_id', 'months', 'coefficient'];

    public function plan()
    {
        return $this->belongsTo(Plan::class);
    }

    /**
     * ✅✅✅ جدید ✅✅✅
     * یک گزینه طرح (مثلاً ۱۲ ماهه) می‌تواند محصولات زیادی داشته باشد
     */
    public function products()
    {
        return $this->belongsToMany(Product::class, 'plan_option_product');
    }
}