<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Product extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'code',
        'category_id', 
        'price',
        'discount_price',
        'stock',
        'image_path',
        'status',   
        'features', // ✅ 1. این خط اضافه شد
    ];

    public function planOptions()
    {
        return $this->belongsToMany(PlanOption::class, 'plan_option_product');
    }

    public function category()
    {
        return $this->belongsTo(Category::class);
    }

    public function getActivePriceAttribute()
    {
        $discount = $this->discount_price;
        return ($discount > 0) ? $discount : $this->price;
    }
    
    /**
     * یک محصول می‌تواند در فاکتورهای زیادی باشد (رابطه چند-به-چند)
     */
    public function invoices()
    {
        return $this->belongsToMany(Invoice::class, 'invoice_product')
                    ->withPivot('quantity', 'price');
    }

    /**
     * ✅✅✅ START: رابطه جدید ✅✅✅
     * یک محصول می‌تواند در باندل‌های زیادی باشد
     */
    public function bundles()
    {
        return $this->belongsToMany(Bundle::class, 'bundle_product')
                    ->withPivot('quantity');
    }
    // ✅✅✅ END: رابطه جدید ✅✅✅
    
    // ✅ 2. این متد اضافه شد
    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'features' => 'array',
        ];
    }
}