<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class User extends Authenticatable
{
    /** @use HasFactory<\Database\Factories\UserFactory> */
    use HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var list<string>
     */
    protected $fillable = [
        'name',
        'email',
        'password',
        'role', // این اضافه شد
        'creator_id', // این اضافه شد
        'job_title', // این اضافه شد
        'education', // این اضافه شد
        'status', // این اضافه شد
        'start_date', // این اضافه شد
        'national_id', // این اضافه شد
        'mobile', // این اضافه شد
        'phone', // این اضافه شد
        'province', // این اضافه شد
        'city', // این اضافه شد
        'store_address', // این اضافه شد
        'profile_picture_path', // این اضافه شد
    ];
    /**
     * The attributes that should be hidden for serialization.
     *
     * @var list<string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'email_verified_at' => 'datetime',
            'password' => 'hashed',
        ];
    }
    
    /**
     * Get the plans created by the user.
     */
    public function plans()
    {
        return $this->hasMany(Plan::class, 'creator_id');
    }

    public function invoices()
    {
        return $this->hasMany(Invoice::class);
    }
    
    // --- این رابطه جدیدی بود که اضافه کردیم ---
    // یک نماینده می‌تواند مشتریان زیادی داشته باشد
    public function customers()
    {
        return $this->hasMany(Customer::class, 'agent_id');
    }
    // --- پایان رابطه جدید ---
    public function documents()
    {
        return $this->hasMany(UserDocument::class);
    }
} // <-- به احتمال زیاد این آکولاد جا افتاده بود