<?php

namespace App\Providers;

use App\Models\Product;
use App\Models\User;
use App\Policies\ProductPolicy;
use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\Log; // این خط را اضافه کنید

class AuthServiceProvider extends ServiceProvider
{
    protected $policies = [
        Product::class => ProductPolicy::class,
    ];

    public function boot(): void
    {
        Gate::define('is-super-admin', function(User $user) {
            // ثبت اطلاعات در فایل لاگ برای دیباگ
            Log::info('--- Checking is-super-admin gate ---');
            Log::info('User Role from DB: ' . $user->role);
            Log::info('Value being compared to: super_admin');
            $result = ($user->role === 'super_admin');
            Log::info('Comparison Result: ' . ($result ? 'true' : 'false'));
            // -----------------------------------------

            return $result;
        });

        Gate::define('is-regional-manager', fn(User $user) => $user->role === 'regional_manager');
        Gate::define('is-agent', fn(User $user) => $user->role === 'agent');
    }
}