<?php

namespace App\Services;

class FarazSmsService
{
    protected $username;
    protected $password;
    protected $from;
    protected $pattern_code;

    public function __construct()
    {
        // اطلاعات API خود را در فایل .env قرار دهید
        $this->username = env('FARAZ_SMS_USERNAME', 'Your_Username');
        $this->password = env('FARAZ_SMS_PASSWORD', 'Your_Password');
        $this->from = env('FARAZ_SMS_FROM', '+98100009');
        $this->pattern_code = env('FARAZ_SMS_LOGIN_PATTERN', '139'); // کد پترن لاگین
    }

    /**
     * ارسال کد OTP برای ورود
     *
     * @param string $to
     * @param string $otpCode
     * @return bool
     */
    public function sendLoginOtp(string $to, string $otpCode)
    {
        // اطمینان از اینکه شماره با فرمت صحیح است
        $to = $this->formatMobile($to);
        
        // بر اساس API شما، متغیرها باید نام "code" و "name" داشته باشند (یا هرچه در پترن شماست)
        // من "code" را برای کد OTP در نظر می‌گیرم
        $input_data = [
            "code" => $otpCode,
            // "name" => "کاربر" // (در صورت نیاز پترن)
        ];

        $url = "https://ippanel.com/patterns/pattern?username=" . $this->username . 
               "&password=" . urlencode($this->password) . 
               "&from=" . $this->from . 
               "&to=" . json_encode([$to]) . 
               "&input_data=" . urlencode(json_encode($input_data)) . 
               "&pattern_code=" . $this->pattern_code;

        try {
            $handler = curl_init($url);
            curl_setopt($handler, CURLOPT_CUSTOMREQUEST, "POST");
            curl_setopt($handler, CURLOPT_POSTFIELDS, $input_data);
            curl_setopt($handler, CURLOPT_RETURNTRANSFER, true);
            $response = curl_exec($handler);
            curl_close($handler);

            // (شما می‌توانید $response را لاگ کنید تا از ارسال موفق مطمئن شوید)
            // Log::info('Faraz SMS Response: ' . $response);
            
            return true; // (فرض بر ارسال موفق)

        } catch (\Exception $e) {
            // Log::error('Faraz SMS Error: ' . $e->getMessage());
            return false;
        }
    }

    /**
     * فرمت کردن شماره موبایل (مثال: 0936 -> 936)
     * (بسته به نیاز API فراز ممکن است متفاوت باشد)
     */
    private function formatMobile(string $mobile)
    {
        if (substr($mobile, 0, 1) === '0') {
            return substr($mobile, 1);
        }
        if (substr($mobile, 0, 3) === '+98') {
            return substr($mobile, 3);
        }
        return $mobile;
    }
}