<?php

use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__.'/../routes/web.php',
        commands: __DIR__.'/../routes/console.php',
        health: '/up',
    )
    ->withMiddleware(function (Middleware $middleware) {
        
        // (این برای خروج از سایر دستگاه‌ها باقی می‌ماند)
        $middleware->web(append: [
            \Illuminate\Session\Middleware\AuthenticateSession::class,
        ]);
        
        $middleware->alias([
            'is.agent' => \App\Http\Middleware\CheckAgentRole::class,
            'is.regional-manager' => \App\Http\Middleware\CheckRegionalManagerRole::class,
            'is.accountant' => \App\Http\Middleware\CheckAccountantRole::class,
            'is.super-admin' => \App\Http\Middleware\CheckSuperAdminRole::class,
            
            // ❌❌❌ میدل‌ور OTP از اینجا حذف شد ❌❌❌
        ]);
        
    })
    ->withExceptions(function (Exceptions $exceptions) {
        //
    })->create();