<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->string('role'); // نقش: super_admin, regional_manager, agent
            $table->foreignId('creator_id')->nullable()->constrained('users'); // شناسه سازنده
            $table->string('job_title')->nullable(); // عنوان شغلی
            $table->string('education')->nullable(); // مدرک تحصیلی
            $table->string('status')->default('active'); // وضعیت: active, inactive
            $table->date('start_date')->nullable(); // تاریخ شروع همکاری
            $table->string('national_id')->nullable()->unique(); // کد ملی
            $table->string('mobile')->nullable()->unique(); // شماره موبایل
            $table->string('phone')->nullable(); // تلفن ثابت
            $table->string('province')->nullable(); // استان
            $table->string('city')->nullable(); // شهر
            $table->text('store_address')->nullable(); // آدرس فروشگاه
            $table->string('profile_picture_path')->nullable(); // مسیر عکس پروفایل
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            //
        });
    }
};
