<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('customers', function (Blueprint $table) {
            $table->id();
            $table->foreignId('agent_id')->constrained('users')->onDelete('cascade'); // نماینده‌ای که این مشتری را ثبت کرده
            $table->string('name');
            $table->string('national_id')->nullable()->unique(); // کد ملی
            $table->string('mobile')->nullable()->unique(); // شماره موبایل
            $table->string('phone')->nullable();
            $table->text('address')->nullable();
            $table->text('details')->nullable(); // سایر جزئیات
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('customers');
    }
};
