<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
	public function up(): void
		{
			Schema::table('invoices', function (Blueprint $table) {
				
				// ۱. ستون customer_id را فقط در صورتی اضافه کن که از قبل وجود نداشته باشد
				if (!Schema::hasColumn('invoices', 'customer_id')) {
					$table->foreignId('customer_id')->nullable()->after('plan_option_id')->constrained('customers');
				}

				// ۲. ستون‌های قدیمی را فقط در صورتی حذف کن که هنوز وجود داشته باشند
				if (Schema::hasColumn('invoices', 'buyer_name')) {
					$table->dropColumn('buyer_name');
				}
				if (Schema::hasColumn('invoices', 'buyer_national_id')) {
					$table->dropColumn('buyer_national_id');
				}
				if (Schema::hasColumn('invoices', 'buyer_mobile')) {
					$table->dropColumn('buyer_mobile');
				}
				if (Schema::hasColumn('invoices', 'buyer_details')) {
					$table->dropColumn('buyer_details');
				}
			});
		}
		/**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
