<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('products', function (Blueprint $table) {
            // اطمینان از وجود ستون قیمت پایه (اگر در مایگریشن قبلی حذف شده بود)
            if (!Schema::hasColumn('products', 'price')) {
                $table->decimal('price', 12, 2)->after('code')->default(0);
            }
            // اضافه کردن ستون قیمت تخفیفی (اختیاری)
            if (!Schema::hasColumn('products', 'discount_price')) {
                $table->decimal('discount_price', 12, 2)->nullable()->after('price');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('products', function (Blueprint $table) {
            //
        });
    }
};
