<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('products', function (Blueprint $table) {
            // ۱. ستون category_id را اضافه کن
            // (آن را بعد از ستون 'code' قرار می‌دهیم تا مرتب باشد)
            $table->foreignId('category_id')
                  ->nullable() // اجازه می‌دهیم محصولی بدون دسته‌بندی هم ثبت شود
                  ->after('code')
                  ->constrained('categories') // به جدول 'categories' متصل شو
                  ->onDelete('set null'); // اگر دسته‌بندی حذف شد، این فیلد را null کن (محصول حذف نشود)
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('products', function (Blueprint $table) {
            // ۱. ابتدا کلید خارجی را حذف کن
            $table->dropForeign(['category_id']);
            // ۲. سپس ستون را حذف کن
            $table->dropColumn('category_id');
        });
    }
};