<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
        {
            Schema::table('invoices', function (Blueprint $table) {
                
                // ✅ قدم ۱: ابتدا «قفل» (کلید خارجی) را حذف می‌کنیم
                $table->dropForeign('invoices_product_id_foreign');
                
                // ✅ قدم ۲: حالا ستون را حذف می‌کنیم
                $table->dropColumn('product_id');
            });
        }

        public function down(): void
        {
            Schema::table('invoices', function (Blueprint $table) {
                // برای بازگرداندن تغییرات (کامل‌تر شد)
                $table->unsignedBigInteger('product_id')->nullable()->after('user_id');
                // و قفل را دوباره اضافه می‌کنیم
                $table->foreign('product_id', 'invoices_product_id_foreign')->references('id')->on('products');
            });
        }
};
