<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
        {
            // این جدول، سبد خرید ماست که فاکتور را به محصولات وصل می‌کند
            Schema::create('invoice_product', function (Blueprint $table) {
                $table->id();
                
                // اتصال به فاکتور
                $table->foreignId('invoice_id')->constrained()->onDelete('cascade');
                
                // اتصال به محصول
                $table->foreignId('product_id')->constrained()->onDelete('cascade');
                
                $table->integer('quantity')->default(1); // تعداد محصول
                $table->decimal('price', 15, 2); // قیمت محصول در لحظه خرید
                
                $table->timestamps();
            });
        }

        // متد down() را هم برای اطمینان کامل کنید
        public function down(): void
        {
            Schema::dropIfExists('invoice_product');
        }
};
