<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB; 

return new class extends Migration
{
    public function up(): void
    {
        // ما تمام قیمت‌ها را ۱۰ برابر می‌کنیم تا به ریال تبدیل شوند
        
        // ۱. جدول محصولات
        DB::table('products')->update([
            'price' => DB::raw('price * 10'),
            'discount_price' => DB::raw('discount_price * 10')
        ]);
        
        // ۲. جدول فاکتورها
        DB::table('invoices')->update([
            'final_price' => DB::raw('final_price * 10'),
            'paid_amount_cash' => DB::raw('paid_amount_cash * 10')
        ]);
        
        // ۳. جدول سبد خرید (آیتم‌های فاکتور)
        DB::table('invoice_product')->update([
            'price' => DB::raw('price * 10')
        ]);
    }

    public function down(): void
    {
        // برگرداندن به تومان (تقسیم بر ۱۰)
        DB::table('products')->update([
            'price' => DB::raw('price / 10'),
            'discount_price' => DB::raw('discount_price / 10')
        ]);
        DB::table('invoices')->update([
            'final_price' => DB::raw('final_price / 10'),
            'paid_amount_cash' => DB::raw('paid_amount_cash / 10')
        ]);
        DB::table('invoice_product')->update([
            'price' => DB::raw('price / 10')
        ]);
    }
};