<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('invoices', function (Blueprint $table) {
            // ستون جدید برای ذخیره مسیرهای ۱۶ فایل چک
            // ما از JSON استفاده می‌کنیم تا آرایه‌ای از مسیرها را ذخیره کنیم
            $table->json('cheque_document_paths')->nullable()->after('document_paths');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('invoices', function (Blueprint $table) {
            $table->dropColumn('cheque_document_paths');
        });
    }
};