<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // ۱. جدول محصولات
        Schema::table('products', function (Blueprint $table) {
            // تغییر نوع ستون برای پذیرش اعداد بزرگتر (تا ۹۹۹ تریلیون ریال)
            $table->decimal('price', 15, 2)->change();
            $table->decimal('discount_price', 15, 2)->nullable()->change();
        });

        // ۲. جدول پیش فاکتورها
        Schema::table('invoices', function (Blueprint $table) {
            $table->decimal('final_price', 15, 2)->change();
            $table->decimal('paid_amount_cash', 15, 2)->default(0)->change();
        });

        // ۳. جدول سبد خرید (آیتم‌های فاکتور)
        Schema::table('invoice_product', function (Blueprint $table) {
            $table->decimal('price', 15, 2)->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // (بازگرداندن به حالت قبل در صورت نیاز)
        Schema::table('products', function (Blueprint $table) {
            $table->decimal('price', 12, 2)->change();
            $table->decimal('discount_price', 12, 2)->nullable()->change();
        });
        Schema::table('invoices', function (Blueprint $table) {
            $table->decimal('final_price', 12, 2)->change();
            $table->decimal('paid_amount_cash', 12, 2)->default(0)->change();
        });
        Schema::table('invoice_product', function (Blueprint $table) {
            $table->decimal('price', 12, 2)->change();
        });
    }
};