<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        // حذف جدول اتصال قدیمی (اگر وجود داشت)
        Schema::dropIfExists('plan_product');

        // ساخت جدول اتصال جدید
        Schema::create('plan_option_product', function (Blueprint $table) {
            $table->id();
            // اتصال به گزینه طرح (مثلاً: ۱۲ ماهه)
            $table->foreignId('plan_option_id')->constrained('plan_options')->onDelete('cascade');
            // اتصال به محصول
            $table->foreignId('product_id')->constrained('products')->onDelete('cascade');
            
            $table->unique(['plan_option_id', 'product_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('plan_option_product');
        
        // (بازگرداندن جدول قدیمی در صورت نیاز)
        Schema::create('plan_product', function (Blueprint $table) {
             $table->id();
             $table->foreignId('plan_id')->constrained('plans')->onDelete('cascade');
             $table->foreignId('product_id')->constrained('products')->onDelete('cascade');
         });
    }
};