<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            تکمیل پرداخت فاکتور شماره {{ $invoice->id }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-3xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">

                    {{-- نمایش پیام موفقیت (از InvoiceController) --}}
                    @if(session('success'))
                        <div class="mb-4 p-4 text-sm text-green-700 bg-green-100 rounded-lg" role="alert">
                            {{ session('success') }}
                        </div>
                    @endif
                    
                    <h3 class="text-lg font-bold border-b pb-4">خلاصه فاکتور</h3>
                    
                    <div class="space-y-3 mt-4">
                        <p class="flex justify-between">
                            <span class="text-gray-600">مشتری:</span>
                            <span class="font-medium">{{ $invoice->customer->name }}</span>
                        </p>
                        <p class="flex justify-between">
                            <span class="text-gray-600">محصول:</span>
                            <span class="font-medium">{{ $invoice->product->name }}</span>
                        </p>
                        <p class="flex justify-between">
                            <span class="text-gray-600">طرح:</span>
                            <span class="font-medium">{{ $invoice->planOption->plan->name }} ({{ $invoice->planOption->months }} ماهه)</span>
                        </p>
                        <hr class="my-4">
                        <p class="flex justify-between text-xl font-bold text-green-700">
                            <span>مبلغ نهایی قابل پرداخت:</span>
                            <span>{{ number_format($invoice->final_price) }} تومان</span>
                        </p>
                    </div>

                    <div class="mt-8 text-center">
                        <p class="text-sm text-gray-500 mb-4">
                            شما در حال انتقال به درگاه پرداخت اعتباری (شبیه‌سازی شده) هستید.
                        </p>
                        
                        {{-- 
                            این فرم به متد redirectToGateway در PaymentController ارسال می‌شود 
                            تا منطق شبیه‌سازی درگاه را اجرا کند.
                        --}}
                        <form action="{{ route('payment.redirect', $invoice->id) }}" method="POST">
                            @csrf
                            <x-primary-button class="text-lg px-8 py-3">
                                انتقال به درگاه پرداخت
                            </x-primary-button>
                        </form>
                    </div>

                </div>
            </div>
        </div>
    </div>
</x-app-layout>