<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            افزودن باندل جدید
        </h2>
    </x-slot>

    <div class="py-12" x-data="bundleForm()">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <form action="{{ route('admin.bundles.store') }}" method="POST">
                @csrf
                <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg p-6">
                    
                    {{-- بخش اطلاعات اصلی باندل --}}
                    <h3 class="text-lg font-semibold border-b pb-2 mb-4">اطلاعات باندل</h3>
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                        <div>
                            <x-input-label for="name" value="نام باندل *" />
                            <x-text-input id="name" name="name" type="text" class="mt-1 block w-full" :value="old('name')" required />
                            <x-input-error :messages="$errors->get('name')" class="mt-2" />
                        </div>
                        <div>
                            <x-input-label for="price" value="قیمت کل باندل (ریال) *" />
                            <x-text-input id="price" name="price" type="number" class="mt-1 block w-full" :value="old('price')" required />
                            <x-input-error :messages="$errors->get('price')" class="mt-2" />
                        </div>
                        <div>
                                <x-input-label for="status" value="وضعیت" />
                                <select name="status" id="status" class="border-gray-300 rounded-md shadow-sm block mt-1 w-full">
                                    <option value="1">فعال</option>
                                    <option value="0">غیرفعال</option>
                                </select>
                                
                                {{-- ✅ اصلاح شده --}}
                                <x-input-error :messages="$errors->get('status')" class="mt-2" />
                            </div>
                    </div>

                    <hr class="my-8">

                    {{-- بخش انتخاب محصولات --}}
                    <h3 class="text-lg font-semibold border-b pb-2 mb-4">محصولات باندل (حداقل ۱)</h3>
                    <x-input-error :messages="$errors->get('products')" class="mt-2" />
                    
                    <div class="space-y-4">
                        {{-- ✅✅✅ START: اصلاحیه خطای Undefined constant "index" ✅✅✅ --}}
                        <template x-for="(product, index) in selectedProducts" :key="index">
                            <div class="p-4 border rounded-lg grid grid-cols-1 md:grid-cols-3 gap-4 relative">
                                <div class="md:col-span-2">
                                    <label x-bind:for="'product_id_' + index" class="block font-medium text-sm text-gray-700">محصول *</label>
                                    <select x-bind:id="'product_id_' + index" x-bind:name="'products[' + index + '][id]'" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm" x-model="product.id" required>
                                        <option value="">-- انتخاب محصول --</option>
                                        @foreach($products as $p)
                                            <option value="{{ $p->id }}">{{ $p->name }} (کد: {{ $p->code }} / موجودی: {{ $p->stock }})</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div>
                                    <label x-bind:for="'quantity_' + index" class="block font-medium text-sm text-gray-700">تعداد *</label>
                                    <x-text-input x-bind:id="'quantity_' + index" x-bind:name="'products[' + index + '][quantity]'" type="number" class="mt-1 block w-full" min="1" x-model="product.quantity" required />
                                </div>
                                
                                <button type="button" @click="removeProduct(index)"
                                        class="absolute top-2 left-2 text-red-500 hover:text-red-700">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor"><path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd" /></svg>
                                </button>
                            </div>
                        </template>
                        {{-- ✅✅✅ END: اصلاحیه ✅✅✅ --}}
                    </div>

                    <button type="button" @click="addProduct" class="mt-4 px-3 py-1 bg-blue-500 text-white rounded-md text-sm hover:bg-blue-600">
                        + افزودن محصول دیگر
                    </button>

                    <div class="flex items-center justify-end mt-6 border-t pt-6">
                        <x-primary-button>
                            ذخیره باندل
                        </x-primary-button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <script>
        function bundleForm(selectedProducts = []) {
            return {
                selectedProducts: selectedProducts.length > 0 ? selectedProducts : [{ id: '', quantity: 1 }],
                addProduct() {
                    this.selectedProducts.push({ id: '', quantity: 1 });
                },
                removeProduct(index) {
                    if (this.selectedProducts.length > 1) {
                        this.selectedProducts.splice(index, 1);
                    } else {
                        alert('باندل باید حداقل شامل یک محصول باشد.');
                    }
                }
            }
        }
    </script>
</x-app-layout>