<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            مدیریت انبار و موجودی کالاها
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">

            {{-- فرم جستجو --}}
            <div class="bg-white shadow-sm sm:rounded-lg mb-4">
                <form method="GET" action="{{ route('admin.inventory.index') }}" class="p-4 flex gap-4">
                    <x-text-input type="text" 
                                  name="search" 
                                  placeholder="جستجوی محصول (نام یا کد)..." 
                                  value="{{ request('search') }}" 
                                  class="w-full" />
                    <x-primary-button>جستجو</x-primary-button>
                </form>
            </div>

            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="text-gray-900">
                    <div class="overflow-x-auto">
                        <table class="min-w-full divide-y divide-gray-200">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">محصول</th>
                                    <th class="px-6 py-3 text-center text-xs font-medium text-gray-500 uppercase">موجودی فعلی</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">عملیات انبار</th>
                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200">
                                @forelse($products as $product)
                                    <tr class="hover:bg-gray-50">
                                        {{-- نام و کد محصول --}}
                                        <td class="px-6 py-4">
                                            <div class="font-medium">{{ $product->name }}</div>
                                            <div class="text-sm text-gray-500">{{ $product->code }}</div>
                                        </td>
                                        
                                        {{-- موجودی فعلی --}}
                                        <td class="px-6 py-4 text-center">
                                            <span class="text-lg font-bold @if($product->stock <= 5) text-red-600 @else text-green-600 @endif">
                                                {{ $product->stock }}
                                            </span>
                                        </td>
                                        
                                        {{-- فرم آپدیت موجودی --}}
                                        <td class="px-6 py-4">
                                            {{-- ✅✅✅ START: اصلاحیه این خط ✅✅✅ --}}
                                            <form action="{{ route('admin.inventory.stock.update', $product->id) }}" method="POST" class="flex items-center justify-end gap-2">
                                            {{-- ✅✅✅ END: اصلاحیه ✅✅✅ --}}
                                                @csrf
                                                @method('PATCH')
                                                
                                                <select name="stock_action" class="border-gray-300 rounded-md shadow-sm py-1 text-sm" style="width: 100px;">
                                                    <option value="set">تنظیم</option>
                                                    <option value="add">افزودن</option>
                                                    <option value="subtract">کسر</option>
                                                </select>
                                                
                                                <x-text-input type="number" 
                                                              name="quantity" 
                                                              class="py-1 text-sm" 
                                                              style="width: 100px;"
                                                              value="0"
                                                              min="0"
                                                              required />
                                                              
                                                <x-primary-button type="submit" class="py-1.5">
                                                    ذخیره
                                                </x-primary-button>
                                            </form>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="3" class="text-center py-6">محصولی یافت نشد.</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    
                    @if($products->hasPages())
                        <div class="p-4 border-t">
                            {{ $products->links() }}
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</x-app-layout>