<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{-- ✅ تغییر نام --}}
            جزئیات پیش فاکتور شماره {{ $invoice->id }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8 grid grid-cols-1 md:grid-cols-3 gap-6">
            
            {{-- اطلاعات اصلی --}}
            <div class="md:col-span-2 bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900 space-y-4">

                    {{-- اطلاعات مشتری --}}
                    <h3 class="text-lg font-bold border-b pb-2">اطلاعات مشتری</h3>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <p><strong>نام مشتری:</strong> {{ $invoice->customer->name ?? 'حذف شده' }}</p>
                        <p><strong>کد ملی:</strong> {{ $invoice->customer->national_id ?? '-' }}</p>
                        <p><strong>موبایل:</strong> {{ $invoice->customer->mobile ?? '-' }}</p>
                        <p class="md:col-span-2"><strong>آدرس:</strong> {{ $invoice->customer->address ?? '-' }}</p>
                    </div>
                    <p class="pt-4 border-t">
                        <strong>ثبت توسط نماینده:</strong> {{ $invoice->user->name ?? 'حذف شده' }}
                    </p>

                    {{-- بخش سبد خرید --}}
                    <h3 class="text-lg font-bold border-b pb-2 mt-6">اطلاعات طرح و محصولات</h3>
                    <p><strong>طرح اقساط:</strong> {{ $invoice->planOption->plan->name }} ({{ $invoice->planOption->months }} ماهه)</p>
                    
                    <div class="overflow-x-auto border rounded-lg mt-4">
                        <table class="min-w-full">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th class="py-2 px-3 text-right text-sm">محصول</th>
                                    <th class="py-2 px-3 text-center text-sm">تعداد</th>
                                    <th class="py-2 px-3 text-left text-sm">جمع (پایه - ریال)</th>
                                </tr>
                            </thead>
                            <tbody class="divide-y">
                                @php $totalBase = 0; @endphp
                                @foreach($invoice->products as $product)
                                    @php $itemTotalBase = $product->pivot->price * $product->pivot->quantity; @endphp
                                    <tr>
                                        <td class="p-3">{{ $product->name }}</td>
                                        <td class="p-3 text-center">{{ $product->pivot->quantity }}</td>
                                        <td class="p-3 text-left font-medium">{{ number_format($itemTotalBase) }}</td>
                                    </tr>
                                    @php $totalBase += $itemTotalBase; @endphp
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    
                    <div class="mt-4 space-y-2">
                        <p class="flex justify-between"><span>جمع پایه (ریال):</span> <span>{{ number_format($totalBase) }}</span></p>
                        <p class="flex justify-between"><span>کارمزد اقساط (ریال):</span> <span>{{ number_format($invoice->final_price - $totalBase) }}</span></p>
                        <p class="text-xl font-bold text-green-700 flex justify-between border-t pt-2 mt-2">
                            {{-- ✅ تغییر نام --}}
                            <span>مبلغ نهایی پیش فاکتور (ریال):</span> 
                            <span>{{ number_format($invoice->final_price) }}</span>
                        </p>
                    </div>
                </div>
            </div>

            {{-- ✅✅✅ START: منطق شرطی اصلاح شده (فاز ۲) ✅✅✅ --}}
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    
                    {{-- اگر کاربر نماینده نباشد (یعنی مدیر منطقه، حسابدار یا ادمین کل بود) --}}
                    @if(auth()->user()->role !== 'agent')
                        
                        <h3 class="text-lg font-bold border-b pb-2">مدارک آپلود شده</h3>
                        @if(!empty($documents) && count($documents) > 0)
                            <ul class="list-disc list-inside mt-2 space-y-2">
                                @foreach($documents as $document)
                                    <li>
                                        <a href="{{ asset('storage/' . $document) }}" target="_blank" class="text-indigo-600 hover:underline">
                                            دانلود مدرک
                                        </a>
                                    </li>
                                @endforeach
                            </ul>
                        @else
                            <p class="mt-2 text-sm text-gray-500">هیچ مدرکی آپلود نشده است.</p>
                        @endif

                        <h3 class="text-lg font-bold border-b pb-2 mt-6">تغییر وضعیت</h3>
                        
                        {{-- ✅ تعیین روت بر اساس نقش --}}
                        @php
                            $updateRoute = match(auth()->user()->role) {
                                'super_admin' => route('admin.invoices.update_status', $invoice->id),
                                'accountant' => route('accountant.invoices.update_status', $invoice->id),
                                'regional_manager' => route('regional-manager.invoices.update_status', $invoice->id),
                                default => '#'
                            };
                        @endphp
                        
                        <form action="{{ $updateRoute }}" method="POST" class="mt-4">
                            @csrf
                            @method('PATCH')
                            <select name="status" class="w-full border-gray-300 rounded-md">
                                
                                {{-- ✅ محدودیت "طرح A" برای مدیر منطقه --}}
                                @if(auth()->user()->role === 'regional_manager' && $invoice->status === 'pending')
                                    {{-- اگر مدیر منطقه بود و وضعیت "pending" بود، این گزینه را غیرفعال کن --}}
                                    <option value="pending" @selected($invoice->status == 'pending') disabled>در انتظار پرداخت (تایید توسط حسابدار)</option>
                                @else
                                    {{-- در غیر این صورت (اگر ادمین/حسابدار بود یا وضعیت pending نبود) --}}
                                    <option value="pending" @selected($invoice->status == 'pending')>در انتظار پرداخت</option>
                                @endif
                                
                                <option value="processing" @selected($invoice->status == 'processing')>در حال بررسی</option>
                                <option value="shipped" @selected($invoice->status == 'shipped')>ارسال شده</option>
                                <option value="delivered" @selected($invoice->status == 'delivered')>تحویل داده شده</option>
                                <option value="rejected" @selected($invoice->status == 'rejected')>لغو شده</option>
                            </select>
                            <x-primary-button class="mt-3 w-full justify-center">ذخیره وضعیت</x-primary-button>
                        </form>

                    @else
                        {{-- نماینده: نمایش پیام فقط خواندنی (کد قبلی شما) --}}
                        <h3 class="text-lg font-bold border-b pb-2">وضعیت پیش فاکتور</h3>
                        <span class="text-base font-semibold px-3 py-1 rounded-full mt-4 inline-block {{ match($invoice->status) {
                            'pending' => 'bg-yellow-100 text-yellow-800',
                            'processing' => 'bg-blue-100 text-blue-800',
                            'shipped' => 'bg-indigo-100 text-indigo-800',
                            'delivered' => 'bg-green-100 text-green-800',
                            'rejected' => 'bg-red-100 text-red-800',
                            default => 'bg-gray-100 text-gray-800',
                        } }}">
                            {{ __($invoice->status) }}
                        </span>
                        <p class="text-gray-600 mt-4 text-sm">پنل نماینده (فقط خواندنی)</p>
                    @endif


                    {{-- دکمه PDF (برای همه نقش‌ها) --}}
                    @php
                        // تعیین روت پرینت بر اساس نقش
                        $printRoute = match(auth()->user()->role) {
                            'regional_manager' => route('regional-manager.invoices.print', $invoice->id),
                            'accountant' => route('accountant.invoices.print', $invoice->id),
                            'super_admin' => route('accountant.invoices.print', $invoice->id), // ادمین از روت حسابدار استفاده می‌کند
                            default => '#' // نماینده دسترسی به این صفحه ندارد
                        };
                    @endphp
                    <a href="{{ $printRoute }}" target="_blank" class="mt-6 inline-flex items-center justify-center w-full px-4 py-2 bg-white border border-gray-300 rounded-md font-semibold text-xs text-gray-700 uppercase hover:bg-gray-50">
                        چاپ PDF
                    </a>
                </div>
            </div>
            {{-- ✅✅✅ END: منطق شرطی ✅✅✅ --}}
            
        </div>
    </div>
</x-app-layout>