<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            ویرایش طرح: {{ $plan->name }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8 grid grid-cols-1 md:grid-cols-2 gap-6">
            
            {{-- بخش ۱: ویرایش اطلاعات اصلی طرح --}}
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    <h3 class="text-lg font-semibold mb-4">اطلاعات اصلی طرح</h3>
                    {{-- ✅ 1. اصلاح نام روت --}}
                    <form action="{{ route('admin.plans.update', $plan->id) }}" method="POST">
                        @csrf
                        @method('PUT')
                        <div class="space-y-4">
                            <div>
                                <x-input-label for="name" :value="__('Plan Name')" />
                                <x-text-input id="name" name="name" type="text" class="mt-1 block w-full" :value="old('name', $plan->name)" required />
                                <x-input-error :messages="$errors->get('name')" class="mt-2" />
                            </div>
                            <div>
                                <x-input-label for="type" :value="__('Plan Type')" />
                                <select id="type" name="type" class="border-gray-300 rounded-md shadow-sm block mt-1 w-full">
                                    <option value="installment" @selected(old('type', $plan->type) == 'installment')>{{ __('Installment') }}</option>
                                    <option value="check" @selected(old('type', $plan->type) == 'check')>{{ __('Check') }}</option>
                                </select>
                                <x-input-error :messages="$errors->get('type')" class="mt-2" />
                            </div>
                            <div class="flex items-center justify-end">
                                <x-primary-button>
                                    به‌روزرسانی طرح
                                </x-primary-button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

            {{-- بخش ۲: افزودن و مدیریت گزینه‌های اقساط --}}
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    <h3 class="text-lg font-semibold mb-4">گزینه‌های اقساط</h3>
                    
                    {{-- فرم افزودن گزینه جدید --}}
                    {{-- ✅ 2. اصلاح نام روت --}}
                    <form action="{{ route('admin.plans.options.store', $plan->id) }}" method="POST" class="grid grid-cols-3 gap-4 items-end mb-6 pb-6 border-b">
                        @csrf
                        <div>
                            <x-input-label for="months" value="تعداد ماه *" />
                            <x-text-input id="months" name="months" type="number" min="1" class="mt-1 block w-full" :value="old('months')" required />
                            <x-input-error :messages="$errors->get('months')" class="mt-2" />
                        </div>
                        <div>
                            <x-input-label for="coefficient" value="ضریب (درصد) *" />
                            <x-text-input id="coefficient" name="coefficient" type="number" step="0.01" min="0" class="mt-1 block w-full" :value="old('coefficient')" required />
                            <x-input-error :messages="$errors->get('coefficient')" class="mt-2" />
                        </div>
                        <x-primary-button class="h-10 justify-center">افزودن</x-primary-button>
                    </form>

                    {{-- لیست گزینه‌های موجود --}}
                    <div class="space-y-2">
                        @forelse($plan->options as $option)
                            <div class="flex justify-between items-center p-3 bg-gray-50 rounded-md">
                                <div>
                                    <span class="font-medium">{{ $option->months }} ماهه</span>
                                    <span class="text-gray-600">(ضریب: {{ $option->coefficient }}٪)</span>
                                </div>
                                {{-- ✅ 3. اصلاح نام روت --}}
                                <form action="{{ route('admin.plans.options.destroy', $option->id) }}" method="POST" onsubmit="return confirm('آیا مطمئن هستید؟')">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="text-red-500 hover:text-red-700 text-sm">حذف</button>
                                </form>
                            </div>
                        @empty
                            <p class="text-gray-500 text-sm">هنوز گزینه‌ای برای این طرح ثبت نشده است.</p>
                        @endforelse
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>