<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                {{-- ✅ اگر فقط خواندنی بود، عنوان را تغییر بده --}}
                @if(isset($is_readonly) && $is_readonly)
                    مشاهده محصولات
                @else
                    {{ __('Product Management') }}
                @endif
            </h2>
            
            {{-- ✅✅✅ START: این بخش شرطی شد ✅✅✅ --}}
            {{-- دکمه‌ها فقط زمانی نمایش داده می‌شوند که در حالت فقط خواندنی نباشیم --}}
            @if(!isset($is_readonly))
            <div class="space-x-4 space-x-reverse">
                <a href="{{ route('admin.products.import.form') }}" class="inline-flex items-center px-4 py-2 bg-white border border-gray-300 rounded-md font-semibold text-xs text-gray-700 uppercase tracking-widest shadow-sm hover:bg-gray-50">
                    درون‌ریزی
                </a>
                <a href="{{ route('admin.products.create') }}" class="inline-flex items-center px-4 py-2 bg-gray-800 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-gray-700">
                    {{ __('Add New Product') }}
                </a>
            </div>
            @endif
            {{-- ✅✅✅ END: بخش شرطی ✅✅✅ --}}

        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">

                    {{-- فرم جستجو و فیلتر (بر اساس ProductController) --}}
                    <form method="GET" action="{{ url()->current() }}" class="mb-6 grid grid-cols-1 md:grid-cols-4 gap-4 items-center">
                        <x-text-input type="text" 
                               name="search" 
                               placeholder="جستجوی محصول (نام یا کد)..." 
                               value="{{ request('search') }}" 
                               class="w-full md:col-span-2" />
                        
                        <select name="status" class="border-gray-300 rounded-md shadow-sm w-full">
                            <option value="">همه وضعیت‌ها</option>
                            <option value="in_stock" @selected(request('status') == 'in_stock')>موجود</option>
                            <option value="out_of_stock" @selected(request('status') == 'out_of_stock')>ناموجود</option>
                        </select>
                        
                        <x-primary-button type="submit" class="w-full justify-center py-3">فیلتر</x-primary-button>
                    </form>

                    {{-- جدول نمایش محصولات (شبیه به عکس) --}}
                    <div class="overflow-x-auto border rounded-lg">
                        <table class="min-w-full divide-y divide-gray-200">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">ردیف</th>
                                    <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">تصویر</th>
                                    <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">عنوان</th>
                                    <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">قیمت (ریال)</th>
                                    <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">موجودی</th>
                                    <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">عملیات</th>
                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200">
                                @forelse($products as $product)
                                    <tr>
                                        <td class="px-6 py-4">{{ $loop->iteration + ($products->firstItem() - 1) }}</td>
                                        <td class="px-6 py-4">
                                            <img src="{{ $product->image_path ? asset('storage/' . $product->image_path) : 'https://via.placeholder.com/80' }}" 
                                                 alt="{{ $product->name }}" 
                                                 class="w-16 h-16 object-cover rounded">
                                        </td>
                                        <td class="px-6 py-4">
                                            <div class="font-medium">{{ $product->name }}</div>
                                            <div class="text-sm text-gray-500">{{ $product->code }}</div>
                                        </td>
                                        <td class="px-6 py-4">
                                            @if($product->discount_price && $product->discount_price > 0)
                                                <div class="font-bold text-red-600">{{ number_format($product->active_price) }}</div>
                                                <div class="text-sm text-gray-500 line-through">{{ number_format($product->price) }}</div>
                                            @else
                                                <div class="font-bold">{{ number_format($product->price) }}</div>
                                            @endif
                                        </td>
                                        <td class="px-6 py-4">
                                            @if($product->stock > 10)
                                                <span class="px-2 py-1 inline-flex text-xs leading-5 font-semibold rounded-full bg-green-100 text-green-800">
                                                    {{ $product->stock }} عدد
                                                </span>
                                            @elseif($product->stock > 0)
                                                <span class="px-2 py-1 inline-flex text-xs leading-5 font-semibold rounded-full bg-yellow-100 text-yellow-800">
                                                    {{ $product->stock }} عدد (کم)
                                                </span>
                                            @else
                                                <span class="px-2 py-1 inline-flex text-xs leading-5 font-semibold rounded-full bg-red-100 text-red-800">
                                                    ناموجود
                                                </span>
                                            @endif
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                            {{-- ✅✅✅ START: این بخش شرطی شد ✅✅✅ --}}
                                            @if(!isset($is_readonly))
                                                <a href="{{ route('admin.products.edit', $product->id) }}" class="inline-flex items-center px-3 py-1 bg-blue-600 border rounded-md font-semibold text-xs text-white uppercase hover:bg-blue-500">
                                                    ویرایش
                                                </a>
                                            @else
                                                <a href="{{ route('regional-manager.products.show', $product->id) }}" class="inline-flex items-center px-3 py-1 bg-gray-600 border rounded-md font-semibold text-xs text-white uppercase hover:bg-gray-500">
                                                    مشاهده جزئیات
                                                </a>
                                            @endif
                                            {{-- ✅✅✅ END: بخش شرطی ✅✅✅ --}}
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="6" class="text-center py-6">هیچ محصولی یافت نشد.</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    {{-- لینک‌های صفحه‌بندی --}}
                    <div class="mt-6">
                        {{ $products->appends(request()->query())->links() }}
                    </div>

                </div>
            </div>
        </div>
    </div>
</x-app-layout>