<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            جزئیات عملکرد نماینده: {{ $user->name }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">

            {{-- ✅ منوی گزارش‌ها اضافه شد --}}
            @include('admin.reports.partials.nav')

            {{-- فرم فیلتر تاریخ --}}
            <div class="bg-white shadow-sm sm:rounded-lg mb-6">
                {{-- فرم به همین صفحه ارسال می‌شود --}}
                <form method="GET" action="{{ route('admin.reports.agent-show', $user->id) }}" class="p-4 flex flex-col md:flex-row gap-4">
                    <div>
                        <x-input-label for="from_date" value="از تاریخ" />
                        <x-text-input id="from_date" name="from_date" type="date" class="mt-1 block w-full" value="{{ request('from_date') }}" />
                    </div>
                    <div>
                        <x-input-label for="to_date" value="تا تاریخ" />
                        <x-text-input id="to_date" name="to_date" type="date" class="mt-1 block w-full" value="{{ request('to_date') }}" />
                    </div>
                    <div class="flex items-end">
                        <x-primary-button type="submit">فیلتر</x-primary-button>
                    </div>
                </form>
            </div>

            {{-- نمودار فروش ماهانه --}}
            <div class="bg-white p-6 rounded-lg shadow-lg mb-8">
                <h4 class="text-gray-800 font-bold mb-4">فروش ماهانه (شمسی)</h4>
                <canvas id="monthSalesChart"></canvas>
            </div>

            <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
                
                {{-- جدول محصولات فروخته شده --}}
                <div class="bg-white p-6 rounded-lg shadow-lg">
                    <h4 class="text-gray-800 font-bold mb-4">۱۰ محصول پرفروش (تعداد)</h4>
                    <div class="overflow-x-auto border rounded-lg">
                        <table class="min-w-full divide-y divide-gray-200">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th class="px-4 py-2 text-right text-xs font-medium text-gray-500 uppercase">محصول</th>
                                    <th class="px-4 py-2 text-center text-xs font-medium text-gray-500 uppercase">تعداد فروش</th>
                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200">
                                @forelse($products_chart_labels as $index => $label)
                                <tr>
                                    <td class="px-4 py-2 text-sm">{{ $label }}</td>
                                    <td class="px-4 py-2 text-sm text-center font-bold">{{ $products_chart_data[$index] }}</td>
                                </tr>
                                @empty
                                <tr><td colspan="2" class="text-center py-4">اطلاعاتی یافت نشد.</td></tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>

                {{-- جدول دسته‌بندی‌های فروخته شده --}}
                <div class="bg-white p-6 rounded-lg shadow-lg">
                    <h4 class="text-gray-800 font-bold mb-4">فروش بر اساس دسته‌بندی (تعداد)</h4>
                    <div class="overflow-x-auto border rounded-lg">
                        <table class="min-w-full divide-y divide-gray-200">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th class="px-4 py-2 text-right text-xs font-medium text-gray-500 uppercase">دسته‌بندی</th>
                                    <th class="px-4 py-2 text-center text-xs font-medium text-gray-500 uppercase">تعداد فروش</th>
                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200">
                                @forelse($categories_chart_labels as $index => $label)
                                <tr>
                                    <td class="px-4 py-2 text-sm">{{ $label }}</td>
                                    <td class="px-4 py-2 text-sm text-center font-bold">{{ $categories_chart_data[$index] }}</td>
                                </tr>
                                @empty
                                <tr><td colspan="2" class="text-center py-4">اطلاعاتی یافت نشد.</td></tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>

            </div>
        </div>
    </div>

    {{-- اسکریپت چارت (کپی شده از داشبورد) --}}
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script>
        // نمودار فروش ماهانه
        const monthCtx = document.getElementById('monthSalesChart');
        if (monthCtx) {
            new Chart(monthCtx, {
                type: 'bar',
                data: {
                    labels: @json($month_chart_labels),
                    datasets: [{
                        label: 'مبلغ فروش (ریال)',
                        data: @json($month_chart_data),
                        backgroundColor: 'rgba(54, 162, 235, 0.5)',
                        borderColor: 'rgba(54, 162, 235, 1)',
                        borderWidth: 1
                    }]
                },
                options: { 
                    scales: { y: { beginAtZero: true } },
                    tooltips: { callbacks: { label: (tooltipItem) => new Intl.NumberFormat('fa-IR').format(tooltipItem.value) + ' ریال' } }
                }
            });
        }
    </script>
</x-app-layout>