<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            لیست تمام نمایندگان (مرتب‌شده بر اساس فروش)
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">

            @include('admin.reports.partials.nav')

            {{-- فرم فیلتر تاریخ --}}
            <div class="bg-white shadow-sm sm:rounded-lg mb-6">
                <form method="GET" action="{{ route('admin.reports.allAgents') }}" class="p-4 flex flex-col md:flex-row gap-4">
                    <div>
                        <x-input-label for="from_date" value="از تاریخ" />
                        <x-text-input id="from_date" name="from_date" type="date" class="mt-1 block w-full" value="{{ request('from_date') }}" />
                    </div>
                    <div>
                        <x-input-label for="to_date" value="تا تاریخ" />
                        <x-text-input id="to_date" name="to_date" type="date" class="mt-1 block w-full" value="{{ request('to_date') }}" />
                    </div>
                    <div class="flex items-end">
                        <x-primary-button type="submit">فیلتر</x-primary-button>
                    </div>
                </form>
            </div>

            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    <div class="overflow-x-auto">
                        <table class="min-w-full divide-y divide-gray-200">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">رتبه</th>
                                    <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">نام نماینده</th>
                                    <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">مجموع فروش (ریال)</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase"></th>
                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200">
                                @forelse($agents as $index => $agent)
                                    <tr>
                                        <td class="px-6 py-4 text-sm">{{ $agents->firstItem() + $index }}</td>
                                        <td class="px-6 py-4 text-sm font-medium">{{ $agent->user->name ?? 'نماینده حذف شده' }}</td>
                                        <td class="px-6 py-4 text-sm font-bold text-green-600">{{ number_format($agent->total_sales) }}</td>
                                        <td class="px-6 py-4 text-left text-sm">
                                            {{-- ✅✅✅ START: اصلاحیه این خط ✅✅✅ --}}
                                            <a href="{{ route('admin.reports.showAgent', ['user' => $agent->user_id, 'from_date' => request('from_date'), 'to_date' => request('to_date')]) }}" class="text-indigo-600 hover:text-indigo-900">
                                                مشاهده جزئیات
                                            </a>
                                            {{-- ✅✅✅ END: اصلاحیه ✅✅✅ --}}
                                        </td>
                                    </tr>
                                @empty
                                    <tr><td colspan="4" class="text-center py-4">هیچ نماینده‌ای یافت نشد.</td></tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    
                    <div class="mt-6">
                        {{ $agents->appends(request()->query())->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>