<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            گزارش فروش بر اساس دسته‌بندی
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">

            @include('admin.reports.partials.nav')

            {{-- فرم فیلتر تاریخ --}}
            <div class="bg-white shadow-sm sm:rounded-lg mb-6">
                {{-- ✅✅✅ START: اصلاحیه این خط ✅✅✅ --}}
                <form method="GET" action="{{ route('admin.reports.byCategory') }}" class="p-4 flex flex-col md:flex-row gap-4">
                {{-- ✅✅✅ END: اصلاحیه ✅✅✅ --}}
                    <div>
                        <x-input-label for="from_date" value="از تاریخ" />
                        <x-text-input id="from_date" name="from_date" type="date" class="mt-1 block w-full" value="{{ request('from_date') }}" />
                    </div>
                    <div>
                        <x-input-label for="to_date" value="تا تاریخ" />
                        <x-text-input id="to_date" name="to_date" type="date" class="mt-1 block w-full" value="{{ request('to_date') }}" />
                    </div>
                    <div class="flex items-end">
                        <x-primary-button type="submit">فیلتر</x-primary-button>
                    </div>
                </form>
            </div>

            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    <div class="overflow-x-auto">
                        <table class="min-w-full divide-y divide-gray-200">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">رتبه</th>
                                    <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">نام دسته‌بندی</th>
                                    <th class="px-6 py-3 text-center text-xs font-medium text-gray-500 uppercase">تعداد فاکتورها</th>
                                    <th class="px-6 py-3 text-center text-xs font-medium text-gray-500 uppercase">تعداد کل آیتم‌های فروش رفته</th>
                                    <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">مجموع مبلغ فروش (ریال)</th>
                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200">
                                @forelse($categories as $index => $category)
                                    <tr>
                                        <td class="px-6 py-4 text-sm">{{ $categories->firstItem() + $index }}</td>
                                        <td class="px-6 py-4 text-sm font-medium">{{ $category->name ?? 'بدون دسته‌بندی' }}</td>
                                        <td class="px-6 py-4 text-sm text-center">{{ $category->total_invoices }}</td>
                                        <td class="px-6 py-4 text-sm text-center font-bold">{{ $category->total_quantity }}</td>
                                        <td class="px-6 py-4 text-sm font-bold text-green-600">{{ number_format($category->total_amount) }}</td>
                                    </tr>
                                @empty
                                    <tr><td colspan="5" class="text-center py-4">فروشی در این بازه زمانی یافت نشد.</td></tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    <div class="mt-4">
                        {{ $categories->appends(request()->query())->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>