<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Company Settings') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    
                    {{-- ✅✅✅ خطای شما اینجا بود (خط ۱۲) ✅✅✅ --}}
                    <form action="{{ route('admin.settings.store') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            
                            {{-- فیلد نام شرکت --}}
                            <div>
                                <x-input-label for="company_name" :value="__('Company Name')" />
                                <x-text-input id="company_name" name="company_name" type="text" class="mt-1 block w-full" :value="old('company_name', $settings['company_name'] ?? '')" />
                                <x-input-error :messages="$errors->get('company_name')" class="mt-2" />
                            </div>

                            {{-- فیلد تلفن شرکت --}}
                            <div>
                                <x-input-label for="company_phone" :value="__('Company Phone')" />
                                <x-text-input id="company_phone" name="company_phone" type="text" class="mt-1 block w-full" :value="old('company_phone', $settings['company_phone'] ?? '')" />
                                <x-input-error :messages="$errors->get('company_phone')" class="mt-2" />
                            </div>

                            {{-- فیلد آدرس شرکت --}}
                            <div class="md:col-span-2">
                                <x-input-label for="company_address" :value="__('Company Address')" />
                                <textarea id="company_address" name="company_address" class="border-gray-300 rounded-md shadow-sm block mt-1 w-full" rows="3">{{ old('company_address', $settings['company_address'] ?? '') }}</textarea>
                                <x-input-error :messages="$errors->get('company_address')" class="mt-2" />
                            </div>

                            {{-- فیلد آپلود لوگو --}}
                            <div class="md:col-span-2">
                                <x-input-label for="company_logo" :value="__('Company Logo (PNG, JPG)')" />
                                <input id="company_logo" name="company_logo" type="file" class="mt-1 block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-violet-50 file:text-violet-700 hover:file:bg-violet-100" />
                                <x-input-error :messages="$errors->get('company_logo')" class="mt-2" />
                                
                                {{-- نمایش لوگوی فعلی --}}
                                @if(!empty($settings['company_logo']))
                                    <div class="mt-4">
                                        <img src="{{ asset('storage/' . $settings['company_logo']) }}" alt="Company Logo" class="h-16 w-auto rounded-md">
                                    </div>
                                @endif
                            </div>

                        </div>

                        <div class="flex items-center justify-end mt-6 border-t pt-6">
                            <x-primary-button>
                                {{ __('Save') }}
                            </x-primary-button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>