{{-- ✅ 1. تعریف پیشوند روت داینامیک بر اساس نقش کاربر --}}
@php
    $routePrefix = auth()->user()->role === 'super_admin' ? 'admin.users.' : 'regional-manager.users.';
@endphp

<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            افزودن کاربر جدید
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">

                    @if ($errors->any())
                        <div class="mb-4 p-4 bg-red-100 text-red-700 border border-red-400 rounded">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    {{-- ✅ 2. اکشن فرم به روت داینامیک اشاره می‌کند --}}
                    <form action="{{ route($routePrefix . 'store') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        
                        {{-- اطلاعات کاربر --}}
                        <h3 class="text-lg font-medium text-gray-900 mb-4">اطلاعات کاربر</h3>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6 border-b pb-6 mb-6">
                            <div>
                                <x-input-label for="name" value="نام*" />
                                <x-text-input id="name" name="name" type="text" class="mt-1 block w-full" :value="old('name')" required />
                            </div>
                            <div>
                                <x-input-label for="mobile" value="شماره موبایل (برای ورود)*" />
                                <x-text-input id="mobile" name="mobile" type="text" class="mt-1 block w-full" :value="old('mobile')" placeholder="مثال: 09123456789" required />
                            </div>
                            <div>
                                <x-input-label for="email" value="ایمیل*" />
                                <x-text-input id="email" name="email" type="email" class="mt-1 block w-full" :value="old('email')" required />
                            </div>
                            
                            <div>
                                <x-input-label for="role" value="نقش*" />
                                <select id="role" name="role" class="border-gray-300 rounded-md shadow-sm block mt-1 w-full" required>
                                    <option value="">-- انتخاب نقش --</option>
                                    
                                    {{-- ✅ 3. مدیر منطقه فقط می‌تواند نماینده بسازد --}}
                                    @if(auth()->user()->role === 'regional_manager')
                                        <option value="agent">نماینده</option>
                                    @else
                                    {{-- ادمین کل همه نقش‌ها را می‌بیند --}}
                                        <option value="regional_manager">مدیر منطقه</option>
                                        <option value="agent">نماینده</option>
                                        <option value="support">پشتیبان</option>
                                        <option value="accountant">حسابدار</option>
                                    @endif
                                </select>
                            </div>

                            <div>
                                <x-input-label for="password" value="گذرواژه*" />
                                <x-text-input id="password" name="password" type="password" class="mt-1 block w-full" required />
                            </div>
                            <div>
                                <x-input-label for="password_confirmation" value="تایید گذرواژه*" />
                                <x-text-input id="password_confirmation" name="password_confirmation" type="password" class="mt-1 block w-full" required />
                            </div>

                            {{-- ✅ 4. فیلد وضعیت (Status) به طور کامل حذف شد --}}
                            
                        </div>


                        {{-- آپلود مدارک (اختیاری) --}}
                        <h3 class="text-lg font-medium text-gray-900 mb-4">آپلود مدارک (اختیاری - حداکثر ۸ فایل)</h3>
                        <div class="space-y-4">
                            {{-- (این بخش برای سادگی فقط یک فیلد را نشان می‌دهد، شما می‌توانید با AlpineJS این را تکرار کنید) --}}
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <div>
                                    <x-input-label for="document_title_0" value="نام مدرک (اختیاری)" />
                                    <x-text-input id="document_title_0" name="documents[0][title]" type="text" class="mt-1 block w-full" placeholder="مثال: تصویر کارت ملی" />
                                </div>
                                <div>
                                    <x-input-label for="document_file_0" value="فایل (PDF, JPG, PNG) (اختیاری)" />
                                    <input id="document_file_0" name="documents[0][file]" type="file" class="mt-1 block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-violet-50 file:text-violet-700 hover:file:bg-violet-100"/>
                                </div>
                            </div>
                            {{-- (می‌توانید فیلدهای documents[1]...[7] را اینجا اضافه کنید) --}}
                        </div>

                        <div class="flex items-center justify-end mt-6">
                            <x-primary-button>
                                ذخیره کاربر
                            </x-primary-button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>