<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Edit User') }}: {{ $user->name }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    <form action="{{ route('admin.users.update', $user->id) }}" method="POST">
                        @csrf
                        @method('PUT')
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div>
                                <x-input-label for="name" :value="__('Name')" />
                                <x-text-input id="name" name="name" type="text" class="mt-1 block w-full" :value="old('name', $user->name)" required autofocus />
                                <x-input-error :messages="$errors->get('name')" class="mt-2" />
                            </div>

                            <!-- ✅✅✅ فیلد جدید موبایل ✅✅✅ -->
                            <div>
                                <x-input-label for="mobile" value="شماره موبایل (برای ورود)*" />
                                <x-text-input id="mobile" name="mobile" type="text" class="mt-1 block w-full" :value="old('mobile', $user->mobile)" required placeholder="مثال: 09123456789" />
                                <x-input-error :messages="$errors->get('mobile')" class="mt-2" />
                            </div>
                            
                            <div>
                                <x-input-label for="email" :value="__('Email')" />
                                <x-text-input id="email" name="email" type="email" class="mt-1 block w-full" :value="old('email', $user->email)" required />
                                <x-input-error :messages="$errors->get('email')" class="mt-2" />
                            </div>
                            
                            <div>
                                <x-input-label for="role" :value="__('Role')" />
                                <select id="role" name="role" class="border-gray-300 rounded-md shadow-sm block mt-1 w-full">
                                    <option value="agent" @selected(old('role', $user->role) == 'agent')>نماینده</option>
                                    <option value="regional_manager" @selected(old('role', $user->role) == 'regional_manager')>مدیر منطقه</option>
                                    <option value="support" @selected(old('role', $user->role) == 'support')>پشتیبان</option>
                                    <option value="accountant" @selected(old('role', $user->role) == 'accountant')>حسابدار</option>
                                </select>
                                <x-input-error :messages="$errors->get('role')" class="mt-2" />
                            </div>

                            <div>
                                <x-input-label for="status" :value="__('Status')" />
                                <select id="status" name="status" class="border-gray-300 rounded-md shadow-sm block mt-1 w-full">
                                    <option value="active" @selected(old('status', $user->status) == 'active')>فعال</option>
                                    <option value="inactive" @selected(old('status', $user->status) == 'inactive')>غیر فعال</option>
                                </select>
                                <x-input-error :messages="$errors->get('status')" class="mt-2" />
                            </div>
                        </div>

                        <hr class="my-6">

                        <h3 class="font-semibold mb-4">تغییر گذرواژه (اختیاری)</h3>
                        <p class="text-sm text-gray-600 mb-4">{{ __('Leave password fields blank if you don\'t want to change the password.') }}</p>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div>
                                <x-input-label for="password" :value="__('New Password')" />
                                <x-text-input id="password" name="password" type="password" class="mt-1 block w-full" />
                                <x-input-error :messages="$errors->get('password')" class="mt-2" />
                            </div>
                            <div>
                                <x-input-label for="password_confirmation" :value="__('Confirm New Password')" />
                                <x-text-input id="password_confirmation" name="password_confirmation" type="password" class="mt-1 block w-full" />
                            </div>
                        </div>

                        <div class="flex items-center justify-end mt-6 border-t pt-6">
                            <x-primary-button>
                                {{ __('Update User') }}
                            </x-primary-button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>