<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            درون‌ریزی کاربران از فایل Excel/CSV
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg p-6">
                <div class="mb-4 text-sm text-gray-700 p-4 bg-blue-50 border border-blue-200 rounded-md">
                    <p><strong>راهنما:</strong></p>
                    <ul class="list-disc list-inside mt-2">
                        <li>فایل شما باید دارای ستون‌های `name`, `email`, `password` و `role` (اختیاری) باشد.</li>
                        <li>ردیف اول فایل به عنوان سربرگ ستون‌ها در نظر گرفته می‌شود.</li>
                        <li>فرمت‌های مجاز: `xlsx` و `csv`.</li>
                    </ul>
                </div>

                {{-- نمایش خطاهای اعتبارسنجی درون‌ریزی --}}
                @if(session('error'))
                    <div class="mb-4 p-4 bg-red-100 text-red-700 border border-red-400 rounded">
                        <strong>خطا در درون‌ریزی!</strong>
                        <div class="mt-2">{!! session('error') !!}</div>
                    </div>
                @endif

                <form action="{{ route('admin.users.import') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div>
                        <label for="file" class="block font-medium text-sm text-gray-700">انتخاب فایل</label>
                        <input type="file" name="file" id="file" class="mt-1 block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-violet-50 file:text-violet-700 hover:file:bg-violet-100" required>
                    </div>
                    <div class="flex justify-end mt-4">
                        <button type="submit" class="inline-flex items-center px-4 py-2 bg-gray-800 border rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-gray-700">
                            درون‌ریزی کاربران
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</x-app-layout>
