{{-- ✅ 1. تعریف پیشوند روت داینامیک بر اساس نقش کاربر --}}
@php
    $routePrefix = auth()->user()->role === 'super_admin' ? 'admin.users.' : 'regional-manager.users.';
@endphp

<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                {{ __('User Management') }}
            </h2>
            <div class="flex space-x-2 space-x-reverse">
                
                {{-- ✅ 2. دکمه درون‌ریزی (فقط ادمین) --}}
                @if(auth()->user()->role == 'super_admin')
                    <a href="{{ route('admin.users.import.form') }}" class="inline-flex items-center px-4 py-2 bg-green-600 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-green-700">
                        درون‌ریزی
                    </a>
                @endif
                
                {{-- ✅ 3. روت داینامیک برای "افزودن کاربر" --}}
                <a href="{{ route($routePrefix . 'create') }}" class="inline-flex items-center px-4 py-2 bg-gray-800 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-gray-700">
                    {{ __('Add New User') }}
                </a>
            </div>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    
                    {{-- ✅ 4. روت داینامیک برای فرم فیلتر --}}
                    <form method="GET" action="{{ route($routePrefix . 'index') }}" class="mb-4">
                        <div class="flex items-center space-x-2 space-x-reverse">
                            <select name="status" class="border-gray-300 rounded-md shadow-sm">
                                <option value="all">همه وضعیت‌ها</option>
                                <option value="active" @selected(request('status') == 'active')>فقط فعال</option>
                                <option value="inactive" @selected(request('status') == 'inactive')>فقط غیر فعال</option>
                            </select>
                            <x-primary-button type="submit">فیلتر</x-primary-button>
                        </div>
                    </form>

                    <div class="overflow-x-auto">
                        <table class="min-w-full divide-y divide-gray-200">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th scope="col" class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">
                                        {{-- ✅ 5. روت داینامیک برای مرتب‌سازی نام --}}
                                        <a href="{{ route($routePrefix . 'index', array_merge(request()->query(), ['sort' => 'name', 'direction' => ($sort === 'name' && $direction === 'asc') ? 'desc' : 'asc'])) }}" class="flex items-center">
                                            {{ __('Name') }}
                                            @if($sort === 'name')
                                                <span class="ml-2 mr-2">@if($direction === 'asc') &uarr; @else &darr; @endif</span>
                                            @endif
                                        </a>
                                    </th>
                                    <th scope="col" class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">
                                        {{-- ✅ 6. روت داینامیک برای مرتب‌سازی ایمیل --}}
                                        <a href="{{ route($routePrefix . 'index', array_merge(request()->query(), ['sort' => 'email', 'direction' => ($sort === 'email' && $direction === 'asc') ? 'desc' : 'asc'])) }}" class="flex items-center">
                                            {{ __('Email') }}
                                            @if($sort === 'email')
                                                <span class="ml-2 mr-2">@if($direction === 'asc') &uarr; @else &darr; @endif</span>
                                            @endif
                                        </a>
                                    </th>
                                    <th scope="col" class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">
                                        {{ __('Role') }}
                                    </th>
                                    <th scope="col" class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">
                                        {{-- ✅ 7. روت داینامیک برای مرتب‌سازی وضعیت --}}
                                        <a href="{{ route($routePrefix . 'index', array_merge(request()->query(), ['sort' => 'status', 'direction' => ($sort === 'status' && $direction === 'asc') ? 'desc' : 'asc'])) }}" class="flex items-center">
                                            وضعیت
                                            @if($sort === 'status')
                                                <span class="ml-2 mr-2">@if($direction === 'asc') &uarr; @else &darr; @endif</span>
                                            @endif
                                        </a>
                                    </th>
                                    <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                        عملیات
                                    </th>
                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200">
                                @forelse($users as $user)
                                    <tr>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                            {{ $user->name }}
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                            {{ $user->email }}
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                            {{ __($user->role) }}
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm">
                                            @if($user->status == 'active')
                                                <span class="text-green-600">فعال</span>
                                            @else
                                                <span class="text-red-600">غیر فعال</span>
                                            @endif
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-left">
                                            {{-- ✅ 8. دکمه‌های ویرایش و حذف (فقط ادمین) --}}
                                            @if(auth()->user()->role == 'super_admin')
                                                <a href="{{ route('admin.users.edit', $user->id) }}" class="text-indigo-600 hover:text-indigo-900">ویرایش</a>
                                                <form action="{{ route('admin.users.destroy', $user->id) }}" method="POST" class="inline" onsubmit="return confirm('آیا از حذف این کاربر مطمئن هستید؟')">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="text-red-600 hover:text-red-900 mr-4">
                                                        حذف
                                                    </button>
                                                </form>
                                            @else
                                                {{-- مدیر منطقه دکمه‌ای نمی‌بیند --}}
                                                -
                                            @endif
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="5" class="px-6 py-4 text-center text-sm text-gray-500">
                                            هیچ کاربری یافت نشد.
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    <div class="mt-4">
                        {{ $users->appends(request()->query())->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>