<x-app-layout>
    {{-- ما هدر را حذف می‌کنیم تا صفحه شبیه فاکتور تمام‌صفحه شود --}}
    {{-- <x-slot name="header">...</x-slot> --}}

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            
            {{-- نمایش خطاهای اعتبارسنجی --}}
            @if ($errors->any())
                <div class="mb-4 p-4 bg-red-100 text-red-700 border border-red-400 rounded">
                    <strong>خطا! لطفاً موارد زیر را اصلاح کنید:</strong>
                    <ul>@foreach ($errors->all() as $error) <li>{{ $error }}</li> @endforeach</ul>
                </div>
            @endif

            {{-- فرم اصلی که تمام صفحه را در بر می‌گیرد --}}
            <form action="{{ route('agent.cart.store') }}" method="POST" enctype="multipart/form-data">
                @csrf
                
                <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                    <div class="p-6 md:p-10 text-gray-900">

                        {{-- عنوان --}}
                        <h2 class="text-2xl font-bold text-center mb-8">شرح کالا</h2>

                        {{-- ✅✅✅ START: جدول آپدیت شده ✅✅✅ --}}
                        <div class="overflow-x-auto border rounded-lg mb-6">
                            <table class="min-w-full">
                                <thead class="bg-gray-100">
                                    <tr>
                                        <th class="py-3 px-4 text-right text-sm font-semibold text-gray-600">ردیف</th>
                                        <th class="py-3 px-4 text-right text-sm font-semibold text-gray-600" style="width: 40%;">عنوان (محصول/باندل)</th>
                                        <th class="py-3 px-4 text-center text-sm font-semibold text-gray-600">تعداد</th>
                                        <th class="py-3 px-4 text-left text-sm font-semibold text-gray-600">مبلغ تک (ریال)</th>
                                        <th class="py-3 px-4 text-left text-sm font-semibold text-gray-600">مبلغ جمع (ریال)</th>
                                        <th class="py-3 px-4 text-left text-sm font-semibold text-gray-600"></th>
                                    </tr>
                                </thead>
                                <tbody class="divide-y">
                                    @php $row = 1; @endphp
                                    {{-- ✅ 1. حلقه بر اساس items --}}
                                    @foreach($cart['items'] as $cartItemId => $item)
                                    <tr>
                                        <td class="p-4">{{ $row++ }}</td>
                                        <td class="p-4">
                                            {{ $item['name'] }}
                                            {{-- نمایش نشانگر باندل --}}
                                            @if($item['type'] === 'bundle')
                                                <span class="text-xs text-blue-600">(باندل)</span>
                                            @endif
                                        </td>
                                        <td class="p-4 text-center">{{ $item['quantity'] }}</td>
                                        <td class="p-4 text-left">{{ number_format($item['price']) }}</td>
                                        <td class="p-4 text-left font-medium">{{ number_format($item['price'] * $item['quantity']) }}</td>
                                        <td class="p-4 text-left">
                                            {{-- ✅ 2. فرم حذف با cart_item_id --}}
                                            <form action="{{ route('agent.cart.remove') }}" method="POST">
                                                @csrf
                                                <input type="hidden" name="cart_item_id" value="{{ $cartItemId }}">
                                                <button type="submit" class="text-red-500 hover:text-red-700 text-xs">(حذف)</button>
                                            </form>
                                        </td>
                                    </tr>
                                    @endforeach
                                    
                                    {{-- ردیف کارمزد (منطق بدون تغییر) --}}
                                    @php
                                        $fee = $cart['totals']['final_price'] - $cart['totals']['base_price'];
                                    @endphp
                                    <tr class="bg-gray-50">
                                        <td class="p-4">{{ $row++ }}</td>
                                        <td class="p-4 font-medium">کارمزد اقساط (طرح: {{ $cart['plan_option_details']['name'] }} {{ $cart['plan_option_details']['months'] }} ماهه)</td>
                                        <td class="p-4 text-center">۱</td>
                                        <td class="p-4 text-left">{{ number_format($fee) }}</td>
                                        <td class="p-4 text-left font-medium">{{ number_format($fee) }}</td>
                                        <td class="p-4"></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        {{-- ✅✅✅ END: جدول آپدیت شده ✅✅✅ --}}

                        {{-- بخش جمع کل (بدون تغییر) --}}
                        <div class="flex justify-end mb-6">
                            <div class="w-full md:w-1/2 lg:w-1/3 space-y-4">
                                <div class="flex justify-between p-3 bg-gray-100 rounded-lg">
                                    <span class="font-medium">مبلغ اولیه (ریال):</span>
                                    <span>{{ number_format($cart['totals']['base_price']) }}</span>
                                </div>
                                <div class="flex justify-between p-3 bg-gray-100 rounded-lg">
                                    <span class="font-medium">کارمزد (ریال):</span>
                                    <span>{{ number_format($fee) }}</span>
                                </div>
                                <div class="flex justify-between p-4 bg-gray-800 text-white rounded-lg text-lg font-bold">
                                    <span>قابل پرداخت (ریال):</span>
                                    <span>{{ number_format($cart['totals']['final_price']) }}</span>
                                </div>
                            </div>
                        </div>

                        {{-- بخش توضیحات (بدون تغییر) --}}
                        <div class="p-4 border rounded-lg bg-gray-50 text-sm text-gray-700 mb-8">
                            <p>این پیش فاکتور هنوز پرداخت نشده است تا وضعیت این سفارش نامشخص تلقی شود. لطفا قادر به ثبت سفارش دیگری در سیستم نخواهید بود.</p>
                            <p class="mt-2">
                                <span class="text-red-600 font-bold">توجه:</span> این پیش فاکتور صرفا جهت ارائه به بانک بوده و فاقد هرگونه ارزش دیگر است.
                            </p>
                        </div>
                        
                        {{-- بخش نهایی (انتخاب مشتری و دکمه ثبت) (بدون تغییر) --}}
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-6 items-start">
                            {{-- انتخاب مشتری و مدارک --}}
                            <div class="md:col-span-2 space-y-4 p-6 border rounded-lg">
                                <h3 class="text-lg font-bold mb-4">اطلاعات نهایی</h3>
                                <div>
                                    <label for="customer_id" class="block font-medium text-sm text-gray-700">انتخاب مشتری *</label>
                                    <select id="customer_id" name="customer_id" class="border-gray-300 rounded-md shadow-sm block mt-1 w-full" required>
                                        <option value="">-- یک مشتری را انتخاب کنید --</option>
                                        @foreach($customers as $customer)
                                            <option value="{{ $customer->id }}" @selected(old('customer_id') == $customer->id)>
                                                {{ $customer->name }} ({{ $customer->national_id ?? '...' }})
                                            </option>
                                        @endforeach
                                    </select>
                                    <a href="{{ route('agent.customers.create') }}" target="_blank" class="text-sm text-indigo-600 hover:text-indigo-700 mt-1 block">ثبت مشتری جدید</a>
                                </div>
                                <div>
                                    <label for="documents" class="block font-medium text-sm text-gray-700">آپلود مدارک (اختیاری)</label>
                                    <input type="file" name="documents[]" id="documents" multiple class="block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-violet-50 file:text-violet-700 hover:file:bg-violet-100 mt-1"/>
                                </div>
                            </div>
                            
                            {{-- دکمه ثبت و خلاصه نهایی --}}
                            <div class="md:col-span-1 p-6 border rounded-lg bg-gray-50">
                                <div class="space-y-2 text-sm mb-4">
                                    <div class="flex justify-between">
                                        <span>مبلغ سفارش (ریال):</span>
                                        <span class="font-medium">{{ number_format($cart['totals']['final_price']) }}</span>
                                    </div>
                                    <div class="flex justify-between">
                                        <span>پرداخت با کارتی = ۰ (ریال)</span>
                                        <span>۰</span>
                                    </div>
                                    <div class="flex justify-between">
                                        <span>کارمزد = ۰ (ریال)</span>
                                        <span>۰</span>
                                    </div>
                                </div>
                                <div class="flex justify-between text-lg font-bold border-t pt-2 mb-4">
                                    <span>قابل پرداخت (ریال):</span>
                                    <span>{{ number_format($cart['totals']['final_price']) }}</span>
                                </div>
                                
                                <x-primary-button class="w-full justify-center text-lg py-3">
                                    ثبت پیش فاکتور
                                </x-primary-button>
                            </div>
                        </div>

                    </div>
                </div>
            </form>
        </div>
    </div>
</x-app-layout>