<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            قدم نهایی: تایید و ثبت فاکتور
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 md:p-10 text-gray-900">

                    {{-- نمایش خطاهای اعتبارسنجی --}}
                    @if ($errors->any())
                        <div class="mb-4 p-4 bg-red-100 text-red-700 border border-red-400 rounded">
                            <strong>خطا! لطفاً موارد زیر را اصلاح کنید:</strong>
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <form action="{{ route('agent.invoices.store') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        {{-- فیلدهای مخفی برای ارسال اطلاعات اصلی --}}
                        <input type="hidden" name="product_id" value="{{ $product->id }}">
                        <input type="hidden" name="plan_option_id" value="{{ $option->id }}">
                        <input type="hidden" name="final_price" value="{{ $finalPrice }}">

                        {{-- بخش ۱: انتخاب مشتری (ضروری) --}}
                        <div class="mb-8 p-6 border rounded-lg">
                            <h3 class="text-lg font-bold mb-4">۱. انتخاب مشتری</h3>
                            <div class="space-y-4">
                                <div>
                                    <label for="customer_id" class="block font-medium text-sm text-gray-700">انتخاب مشتری</label>
                                    <select id="customer_id" name="customer_id" class="border-gray-300 rounded-md shadow-sm block mt-1 w-full" required>
                                        <option value="">-- یک مشتری را انتخاب کنید --</option>
                                        @foreach($customers as $customer)
                                            <option value="{{ $customer->id }}" @selected(old('customer_id') == $customer->id)>
                                                {{ $customer->name }} ({{ $customer->national_id ?? 'بدون کد ملی' }})
                                            </option>
                                        @endforeach
                                    </select>
                                    <small class="text-sm text-gray-600 mt-1">
                                        مشتری مورد نظر در لیست نیست؟ 
                                        <a href="{{ route('agent.customers.create') }}" target="_blank" class="text-indigo-600 hover:text-indigo-700">
                                            مشتری جدید ثبت کنید
                                        </a>
                                    </small>
                                </div>
                            </div>
                        </div>

                        {{-- بخش ۲: پیش‌نمایش فاکتور (شبیه به عکس) --}}
                        <div class="border rounded-lg overflow-hidden">
                            <div class="p-4 bg-gray-50 border-b">
                                <h3 class="text-lg font-bold">۲. شرح کالا (پیش‌نمایش فاکتور)</h3>
                            </div>
                            
                            {{-- جدول شرح کالا --}}
                            <div class="overflow-x-auto">
                                <table class="min-w-full">
                                    <thead class="bg-gray-100">
                                        <tr>
                                            <th class="py-2 px-4 text-right text-sm font-semibold text-gray-600">ردیف</th>
                                            <th class="py-2 px-4 text-right text-sm font-semibold text-gray-600">عنوان</th>
                                            <th class="py-2 px-4 text-left text-sm font-semibold text-gray-600">تعداد</th>
                                            <th class="py-2 px-4 text-left text-sm font-semibold text-gray-600">مبلغ نهایی (تومان)</th>
                                        </tr>
                                    </thead>
                                    <tbody class="divide-y">
                                        <tr>
                                            <td class="p-4">۱</td>
                                            <td class="p-4">
                                                <div class="font-medium">{{ $product->name }}</div>
                                                <div class="text-xs text-gray-500">
                                                    طرح: {{ $option->plan->name }} ({{ $option->months }} ماهه با ضریب {{ $option->coefficient }}٪)
                                                </div>
                                            </td>
                                            <td class="p-4 text-left">۱</td>
                                            <td class="p-4 text-left font-semibold">{{ number_format($finalPrice) }}</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>

                            {{-- جمع کل --}}
                            <div class="p-6 bg-gray-50 border-t flex justify-end">
                                <div class="w-full md:w-1/2 lg:w-1/3 space-y-3">
                                    <div class="flex justify-between text-lg">
                                        <span>مبلغ پایه:</span>
                                        <span class="font-medium">{{ number_format($activePrice) }} تومان</span>
                                    </div>
                                    <div class="flex justify-between text-lg">
                                        <span>کارمزد (اقساط):</span>
                                        <span class="font-medium">{{ number_format($finalPrice - $activePrice) }} تومان</span>
                                    </div>
                                    <hr>
                                    <div class="flex justify-between text-2xl font-bold text-green-700">
                                        <span>قابل پرداخت:</span>
                                        <span>{{ number_format($finalPrice) }} تومان</span>
                                    </div>
                                </div>
                            </div>
                        </div>

                        {{-- بخش ۳: آپلود مدارک و ثبت نهایی --}}
                        <div class="mt-8 p-6 border rounded-lg">
                            <h3 class="text-lg font-bold mb-4">۳. آپلود مدارک و ثبت نهایی</h3>
                            <div>
                                <label for="documents" class="block font-medium text-sm text-gray-700">آپلود مدارک (اختیاری - امکان انتخاب چند فایل)</label>
                                <input type="file" name="documents[]" id="documents" multiple class="block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-violet-50 file:text-violet-700 hover:file:bg-violet-100 mt-1"/>
                            </div>
                            
                            <div class="flex items-center justify-end mt-6">
                                <x-primary-button class="text-lg px-8 py-3">
                                    ثبت نهایی و انتقال به پرداخت
                                </x-primary-button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>